/**
  * @file <loop-functions/example/ForagingLoopFunc.h>
  *
  * @author Antoine Ligot - <aligot@ulb.ac.be>
  *
  * @package ARGoS3-AutoMoDe
  *
  * @license MIT License
  */

#ifndef MIGRATION_ONE_SPOT_LOOP_FUNC
#define MIGRATION_ONE_SPOT_LOOP_FUNC

#include <regex>

#include <argos3/core/simulator/space/space.h>
#include <argos3/plugins/robots/e-puck/simulator/epuck_entity.h>
#include <argos3/plugins/simulator/entities/box_entity.h>
#include "../../../src/CoreLoopFunctions.h"

using namespace argos;

class ChocolateMission6LoopFunction: public CoreLoopFunctions {
  public:
    ChocolateMission6LoopFunction();
    ChocolateMission6LoopFunction(const ChocolateMission6LoopFunction& orig);
    virtual ~ChocolateMission6LoopFunction();

    virtual void Destroy();
    //virtual void Init(TConfigurationNode& t_tree);

    virtual argos::CColor GetFloorColor(const argos::CVector2& c_position_on_plane);
    virtual void PostExperiment();
    virtual void PostStep();
    virtual void Reset();

    Real GetObjectiveFunction();
    UInt32  GetNumRobots();

    CVector3 GetRandomPosition();

    bool IsWithinTriangle(CVector2& c_point_q, CVector2& c_point_a, CVector2& c_point_b, CVector2& c_point_c);
    Real AreaTriangle(CVector2& c_point_a, CVector2& c_point_b, CVector2& c_point_c);
    bool IsPointInTri(CVector2& pt, CVector2& v1, CVector2& v2, CVector2& v3);
    Real CalcTriArea(CVector2& v1, CVector2& v2, CVector2& v3);

    virtual void Init(TConfigurationNode& t_tree);
    //bool IsWithinRectangle(CVector2& vCurrentPoint, Real m_fNestLimit);
    //bool IsWithinCircle(CVector2 c_cEpuckPosition, CVector2& m_cCoordSpot, Real fRadius);
    //void Initialize();
    Real InnerRadious();

    std::regex m_cRegex;

  private:

    Real fRadius;
    CVector2 m_cCoordSpot1;
    CVector2 m_cCoordSpot2;
    CVector2 m_cCoordSpot3;

    CVector2 m_cCoordSpot4;
    CVector2 m_cCoordSpot5;
    CVector2 m_cCoordSpot6;
  
  


    Real m_unScoreSpot;
    Real m_unScoreOutSpot;
    Real m_fObjectiveFunction;
    Real reward;
    Real penalty;
    UInt32 m_unNumberEdges;
    CBoxEntity *pcWall;
    Real sidesize;


    UInt32 numRobots;
    UInt32 m_robotmin;
    

};

#endif